/* Important hooks/ base modifications:
 * EntityArrow: Fire/4 applied to hit target
 */



package net.minecraft.src;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import java.util.Random;

import org.lwjgl.input.Keyboard;

import net.minecraft.client.Minecraft;

public class mod_Mine4Dead extends BaseModMp
{
	public mod_Mine4Dead()
    {
    	ModLoader.SetInGameHook(this,true, false);
    	ModLoader.SetInGUIHook(this,true, false);
    	sendInstance=this;
    	
    	// Add Names and register Blocks here
    	//ModLoader.RegisterBlock(blockAdvFurnaceOn);
    	//ModLoader.AddName(blockAdvFurnaceOff, "Iron Furnace");    	
    	ModLoader.RegisterBlock(blockShrine);
    	ModLoader.AddName(blockShrine, "Golden Shrine");    
    	ModLoader.AddName(darkEnergy, "Corrupted Soul Energy"); 
    	ModLoader.AddName(lightEnergy, "Purified Soul Energy");
    	ModLoader.AddName(darkDiamond, "Corrupted Soul Crystal"); 
    	ModLoader.AddName(lightDiamond, "Purified Soul Crystal");
    	ModLoader.AddName(plantFeather, "Leaf Feather");
    	ModLoader.AddName(plantString, "Leaf String");
    	ModLoader.AddName(woodHelmet, "Woodern Helmet");
    	ModLoader.AddName(woodPlate, "Woodern Chestplate");
    	ModLoader.AddName(woodLegs, "Woodern Leggings");
    	ModLoader.AddName(woodBoots, "Woodern Boots");
    	ModLoader.AddName(swordHoly, "Holy Sword");
    	ModLoader.AddName(swordCorrupted, "Corrupted Sword");
    	ModLoader.AddName(itemLense, "Light Lense");
    	ModLoader.AddName(itemLenseBow, "Lense Bow");
    	ModLoader.AddName(arrowCoal, "Igniting Arrow");
    	ModLoader.AddName(chantBook, "Chant Book");
    	ModLoader.AddName(chantSmite, "Chant: 'Heavens Smiting'");
    	ModLoader.AddName(chantHeal, "Chant: 'Melody of Love'");
    	ModLoader.AddName(chantMind, "Chant: 'Praise the Father'");
    	ModLoader.AddName(chantDark, "Chant: 'Satans Despair'");
    	ModLoader.RegisterBlock(blockTrapWood);
    	ModLoader.AddName(blockTrapWood, "Woodern Trap");  
    	ModLoader.RegisterBlock(blockTrapStone);
    	ModLoader.AddName(blockTrapStone, "Stone Trap"); 
    	ModLoader.RegisterBlock(blockTrapIron);
    	ModLoader.AddName(blockTrapIron, "Bear Trap"); 
    	ModLoader.RegisterBlock(blockTrapStoneX);
    	ModLoader.RegisterBlock(blockTrapIronX);
    	ModLoader.RegisterBlock(blockWeb);
    	ModLoader.AddName(itemWebBall, "Webbing"); 
    	ModLoader.RegisterBlock(blockCorruption);
    	ModLoader.RegisterBlock(blockCorruptionWeak);
    	
    	//Register TileEntitys
    	//ModLoader.RegisterTileEntity(TileEntityAdvFurnace.class, "Iron Furnace");
    	// Do never forget to register TEs... otherwise chunks become unsaveable
    	ModLoader.RegisterTileEntity(TileEntityShrine.class, "Shrine");
    	
    	//Add new smeltings
    	//ModLoader.AddSmelting(Item.ingotIron.shiftedIndex, new ItemStack(ingotAdvIron, 1));
    	
    	//Register SMP-transfer'd GUIs
    	//ModLoaderMp.RegisterGUI(this, 16);
    	ModLoaderMp.RegisterGUI(this, 16);
    	
    	ModLoader.RegisterEntityID(EntityM4DWalkingDead.class, "Walking Dead", 120);
    	ModLoader.RegisterEntityID(EntityM4DCrawlSpider.class, "Crawl Spider", 119);
    	ModLoader.RegisterEntityID(EntityM4DCorruptedCorpse.class, "Corrupted Corpse", 118);
    	ModLoader.RegisterEntityID(EntityM4DMadCow.class, "Mad Cow", 117);
    	ModLoader.RegisterEntityID(EntityM4DDirtEater.class, "Dirt Eater", 116);
    	ModLoader.RegisterEntityID(EntityM4DCrazyChicken.class, "Crazy Chicken", 115);
    	ModLoader.RegisterEntityID(EntityM4DDarkZombie.class, "Dark Zombie", 114);
    	ModLoader.RegisterEntityID(EntityM4DBuster.class, "Buster", 113);
    	ModLoader.RegisterEntityID(EntityM4DCorruptor.class, "Corruptor", 112);
    	ModLoader.RegisterEntityID(EntityM4DWebbingSpider.class, "Webbing Spider", 111);
    	
    	ModLoaderMp.RegisterNetClientHandlerEntity(EntityM4DWebBall.class, 240);
    }
	
	public static EntityPlayer player = null;
	
	/**
	 * Override of BaseModMP method, ned to use SMP-GUIs
	 */
	public GuiScreen HandleGUI(int screenID)
    {
    	player = ModLoader.getMinecraftInstance().thePlayer;
    	if (player==null)
    	{
    		return null;
    	}
    	
    	if(screenID == 16)
        {
            return new GuiShrine(player.inventory, new TileEntityShrine());
        }
    	
    	//Add new GUI-indices here
    /*	if(screenID == 16)
        {
            TileEntityAdvFurnace tileentitything = new TileEntityAdvFurnace();
            return new GuiAdvFurnace(player.inventory, tileentitything);
        }*/
    	return null;
    }
	
	//Declare new blocks and item variables
	//public static Block blockElecFurnaceOn;
    //public static Item ingotAdvIron;
	
	public static Block blockShrine;
	public static Item darkEnergy;
	public static Item lightEnergy;
	public static Item darkDiamond;
	public static Item lightDiamond;
	public static Item plantFeather;
	public static Item plantString;
	public static Item woodHelmet;
	public static Item woodPlate;
	public static Item woodLegs;
	public static Item woodBoots;
	public static Item swordHoly;
	public static Item swordCorrupted;
	public static Item itemLense;
	public static Item itemLenseBow;
	public static Item arrowCoal;
	public static Item chantBook;
	public static Item chantSmite;
	public static Item chantHeal;
	public static Item chantMind;
	public static Item chantDark;
	public static Block blockTrapWood;
	public static Block blockTrapStone;
	public static Block blockTrapIron;
	public static Block blockTrapStoneX;
	public static Block blockTrapIronX;
	public static Block blockWeb;
	public static Item itemWebBall;
	public static Block blockCorruption;
	public static Block blockCorruptionWeak;
	
	
	static 
    { 
		try
    	{
    	System.out.println((new StringBuilder()).append("[M4D] Trying to open M4DConfig.txt...").toString());
    	BufferedReader reader = new BufferedReader(new FileReader(new File("M4DConfig"+".txt")));
    	configLoaded=true;
    	System.out.println((new StringBuilder()).append("[M4D] Found a config file, reading.").toString());
    	loadConfig(reader);
    	}
		catch (Exception f)
    	{
		System.out.println((new StringBuilder()).append("[M4D] Could not find/open M4DConfig.txt, automatic use of standard configurations.").toString());
		configLoaded=false;
    	}
		
		
		
		// Call ned Block-Texture-Load methods
		// BlockAdvFurnace.loadSprites(); 
		BlockShrine.loadSprites(); 
		
		//Initialize the new blocks/items
		//blockAdvFurnaceOff = (new BlockAdvFurnace(mod_IndustrialCraft.getId("blockAdvFurnaceOff",250), false)).setHardness(2.5F).setStepSound(Block.soundMetalFootstep).setBlockName("advFurnace");
		//ingotAdvIron = (new Item(mod_IndustrialCraft.getId("ingotAdvIron",30000))).setIconIndex(ModLoader.addOverride("/gui/items.png", (new StringBuilder()).append("/IndustrialSprites/").append("ingotAdvIron.png").toString())).setItemName("ingotAdvIron");
		//ModLoader.addOverride("/terrain.png",(new StringBuilder()).append("/IndustrialSprites/").append("oreTin.png").toString()))
		
		blockShrine = (new BlockShrine(mod_Mine4Dead.getId("blockShrine",250))).setBlockUnbreakable().setResistance(9001F).setHardness(9001F).setStepSound(Block.soundMetalFootstep).setBlockName("blockShrine").setLightValue(1F);
		darkEnergy = (new Item(mod_Mine4Dead.getId("darkEnergy",30000))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/darkEnergy.png")).setItemName("darkEnergy");
		lightEnergy = (new Item(mod_Mine4Dead.getId("lightEnergy",29999))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/lightEnergy.png")).setItemName("lightEnergy");
		darkDiamond = (new ItemCrystal(mod_Mine4Dead.getId("darkDiamond",29998),false)).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/darkDiamond.png")).setItemName("darkDiamond");
		lightDiamond = (new ItemCrystal(mod_Mine4Dead.getId("lightDiamond",29997),true)).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/lightDiamond.png")).setItemName("lightDiamond");
		plantFeather = (new Item(mod_Mine4Dead.getId("plantFeather",29996))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/plantFeather.png")).setItemName("plantFeather");
		plantString = (new Item(mod_Mine4Dead.getId("plantString",29995))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/plantString.png")).setItemName("plantString");
		woodHelmet = (new ItemArmor(mod_Mine4Dead.getId("woodHelmet",29994), 0, ModLoader.AddArmor("wood"), 0)).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/woodHelmet.png")).setItemName("woodHelmet");
		woodPlate = (new ItemArmor(mod_Mine4Dead.getId("woodPlate",29993), 0, ModLoader.AddArmor("wood"), 1)).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/woodPlate.png")).setItemName("woodPlate");
		woodLegs = (new ItemArmor(mod_Mine4Dead.getId("woodLegs",29992), 0, ModLoader.AddArmor("wood"), 2)).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/woodLegs.png")).setItemName("woodLegs");
		woodBoots = (new ItemArmor(mod_Mine4Dead.getId("woodBoots",29991), 0, ModLoader.AddArmor("wood"), 3)).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/woodBoots.png")).setItemName("woodBoots");
		swordHoly = (new ItemEnchantedSword(mod_Mine4Dead.getId("swordHoly",29990), true)).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/swordHoly.png")).setItemName("swordHoly");
		swordCorrupted = (new ItemEnchantedSword(mod_Mine4Dead.getId("swordCorrupted",29989), false)).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/swordCorrupted.png")).setItemName("swordCorrupted");
		itemLense = (new ItemLense(mod_Mine4Dead.getId("itemLense",29988))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/itemLense.png")).setItemName("itemLense");
		itemLenseBow = (new ItemLenseBow(mod_Mine4Dead.getId("itemLenseBow",29987))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/itemLenseBow.png")).setItemName("itemLenseBow");
		arrowCoal = (new Item(mod_Mine4Dead.getId("arrowCoal",29986))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/arrowCoal.png")).setItemName("arrowCoal");
		chantBook = (new Item(mod_Mine4Dead.getId("chantBook",29985))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/chantBook.png")).setItemName("chantBook");
		chantSmite = (new ItemChantBook(mod_Mine4Dead.getId("chantSmite",29984))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/chantSmite.png")).setItemName("chantSmite");
		chantHeal = (new ItemChantBook(mod_Mine4Dead.getId("chantHeal",29983))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/chantHeal.png")).setItemName("chantHeal");
		chantMind = (new ItemChantBook(mod_Mine4Dead.getId("chantMind",29982))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/chantMind.png")).setItemName("chantMind");
		chantDark = (new ItemChantBook(mod_Mine4Dead.getId("chantDark",29981))).setIconIndex(ModLoader.addOverride("/gui/items.png", "/M4DSprites/chantDark.png")).setItemName("chantDark");
		blockTrapWood = (new BlockTrap(mod_Mine4Dead.getId("blockTrapWood",249), ModLoader.addOverride("/terrain.png","/M4DSprites/blockTrapWood.png"), Material.wood, false)).setHardness(0.5F).setResistance(1F).setStepSound(Block.soundWoodFootstep).setBlockName("blockTrapWood");
		blockTrapStone = (new BlockTrap(mod_Mine4Dead.getId("blockTrapStone",248), ModLoader.addOverride("/terrain.png","/M4DSprites/blockTrapStone.png"), Material.rock, false)).setHardness(1.0F).setResistance(5F).setStepSound(Block.soundStoneFootstep).setBlockName("blockTrapStone");
		blockTrapIron = (new BlockTrap(mod_Mine4Dead.getId("blockTrapIron",247), ModLoader.addOverride("/terrain.png","/M4DSprites/blockTrapIron.png"), Material.iron, false)).setHardness(1.5F).setResistance(50F).setStepSound(Block.soundMetalFootstep).setBlockName("blockTrapIron");
		blockTrapStoneX = (new BlockTrap(mod_Mine4Dead.getId("blockTrapStoneX",246), ModLoader.addOverride("/terrain.png","/M4DSprites/blockTrapStoneX.png"), Material.rock, true)).setHardness(1.0F).setResistance(5F).setStepSound(Block.soundStoneFootstep).setBlockName("blockTrapStoneX");
		blockTrapIronX = (new BlockTrap(mod_Mine4Dead.getId("blockTrapIronX",245), ModLoader.addOverride("/terrain.png","/M4DSprites/blockTrapIronX.png"), Material.iron, true)).setHardness(1.5F).setResistance(50F).setStepSound(Block.soundMetalFootstep).setBlockName("blockTrapIronX");
		blockWeb = (new BlockM4DWeb(mod_Mine4Dead.getId("blockWeb",244), Block.web.blockIndexInTexture)).setHardness(2F).setResistance(0.2F).setLightOpacity(1).setStepSound(Block.soundClothFootstep).setBlockName("blockWeb");
		itemWebBall = (new ItemWebBall(mod_Mine4Dead.getId("itemWebBall",29980))).setIconIndex(Item.snowball.iconIndex).setItemName("itemWebBall");
		blockCorruption = (new BlockCorruption(mod_Mine4Dead.getId("blockCorruption",243), ModLoader.addOverride("/terrain.png","/M4DSprites/blockCorruption.png"), true)).setBlockUnbreakable().setResistance(5F).setStepSound(Block.soundGravelFootstep).setBlockName("blockCorruption");
		blockCorruptionWeak = (new BlockCorruption(mod_Mine4Dead.getId("blockCorruptionWeak",242), blockCorruption.blockIndexInTexture, false)).setHardness(5F).setResistance(5F).setStepSound(Block.soundGravelFootstep).setBlockName("blockCorruption");
        
		AddRecipes(); // ModLoader doesn't call this method naturally, anymore.
		
    }
	
	
	public static void AddRecipes()
	
	{ 	
		// New recipes go in here.
		// ModLoader.AddRecipe(new ItemStack(blockTerraOff, 1), new Object[] {
		//      "#", Character.valueOf('#'), Block.dirt //Cheat
		//     	});
		/*ModLoader.AddRecipe(new ItemStack(lightEnergy, 64), new Object[] {
			      "# ", " #", Character.valueOf('#'), Block.dirt //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(darkEnergy, 64), new Object[] {
		      "# ", "# ", Character.valueOf('#'), Block.dirt //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(swordCorrupted, 1), new Object[] {
		      "#", Character.valueOf('#'), darkEnergy //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(swordHoly, 1), new Object[] {
		      "#", Character.valueOf('#'), lightEnergy //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(itemLense, 1), new Object[] {
		      " # ","# #"," # ", Character.valueOf('#'), lightEnergy //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(itemLenseBow, 1), new Object[] {
		      "#","#","#", Character.valueOf('#'), itemLense //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(arrowCoal, 64), new Object[] {
		      "#","#","#", Character.valueOf('#'), Block.sand //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(Item.arrow, 64), new Object[] {
		      "#",Character.valueOf('#'), arrowCoal //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(chantBook, 1), new Object[] {
		      "###", Character.valueOf('#'), lightEnergy //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(chantSmite, 1,1), new Object[] {
		      "#","B", Character.valueOf('#'), lightEnergy, Character.valueOf('B'), chantBook //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(chantHeal, 1,1), new Object[] {
		      "B","#", Character.valueOf('#'), lightEnergy, Character.valueOf('B'), chantBook //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(chantMind, 1,1), new Object[] {
		      "#B", Character.valueOf('#'), lightEnergy, Character.valueOf('B'), chantBook //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(chantDark, 1,1), new Object[] {
		      "#","B", Character.valueOf('#'), darkEnergy, Character.valueOf('B'), chantBook //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(blockTrapWood, 1), new Object[] {
		      "#", Character.valueOf('#'), Block.planks //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(blockTrapStone, 1), new Object[] {
		      "#", Character.valueOf('#'), blockTrapWood //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(blockTrapIron, 1), new Object[] {
		      "#", Character.valueOf('#'), blockTrapStone //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(Block.torchWood, 64), new Object[] {
		      "#", Character.valueOf('#'), Item.stick //Cheat
		});
		ModLoader.AddRecipe(new ItemStack(blockShrine, 1), new Object[] {
			"###", "###", "###", Character.valueOf('#'), lightDiamond //Cheat
		});*/
		
		
		ModLoader.AddRecipe(new ItemStack(lightDiamond, 1), new Object[] {
		      "###", "###", "###", Character.valueOf('#'), lightEnergy
		});
		ModLoader.AddRecipe(new ItemStack(darkDiamond, 1), new Object[] {
		      "###", "###", "###", Character.valueOf('#'), darkEnergy
		});
		ModLoader.AddRecipe(new ItemStack(Block.cloth, 1, 5), new Object[] {
		      "###", "###", "###", Character.valueOf('#'), plantString
		});
		ModLoader.AddRecipe(new ItemStack(plantFeather, 8), new Object[] {
		      "###", "###", " # ", Character.valueOf('#'), Block.sapling 
		});
		ModLoader.AddRecipe(new ItemStack(plantFeather, 8), new Object[] {
		      "###", "###", " # ", Character.valueOf('#'), Item.reed 
		});
		ModLoader.AddRecipe(new ItemStack(plantFeather, 8), new Object[] {
		      "###", "###", " # ", Character.valueOf('#'), Block.leaves
		});
		ModLoader.AddRecipe(new ItemStack(plantString, 1), new Object[] {
		      "###", "# #", "###", Character.valueOf('#'), Block.sapling
		});
		ModLoader.AddRecipe(new ItemStack(plantString, 1), new Object[] {
		      "###", "# #", "###", Character.valueOf('#'), Item.reed
		});
		ModLoader.AddRecipe(new ItemStack(plantString, 1), new Object[] {
		      "###", "# #", "###", Character.valueOf('#'), Block.leaves
		});
		ModLoader.AddRecipe(new ItemStack(Item.flint, 1), new Object[] {
		      "#", "#", Character.valueOf('#'), Block.gravel
		});
		ModLoader.AddRecipe(new ItemStack(Item.bow, 1), new Object[] {
		      "Is ", "I s", "Is ", Character.valueOf('I'), plantString, Character.valueOf('s'), Item.stick 
		});
		ModLoader.AddRecipe(new ItemStack(Item.arrow, 4), new Object[] {
		      "F", "s", "f", Character.valueOf('f'), plantFeather, Character.valueOf('s'), Item.stick , Character.valueOf('F'), Item.flint 
		});
		ModLoader.AddRecipe(new ItemStack(woodHelmet, 1), new Object[] {
		      "###", "# #",Character.valueOf('#'), Block.wood
		});
		ModLoader.AddRecipe(new ItemStack(woodPlate, 1), new Object[] {
		      "# #", "###", "###",Character.valueOf('#'), Block.wood
		});
		ModLoader.AddRecipe(new ItemStack(woodLegs, 1), new Object[] {
		      "###", "# #", "# #",Character.valueOf('#'), Block.wood
		});
		ModLoader.AddRecipe(new ItemStack(woodBoots, 1), new Object[] {
		      "# #", "# #",Character.valueOf('#'), Block.wood
		});
		ModLoader.AddRecipe(new ItemStack(swordHoly, 1), new Object[] {
		      "CIC", "CIC", "MLM", Character.valueOf('C'), lightDiamond, Character.valueOf('I'), Item.ingotIron, Character.valueOf('L'), Item.leather, Character.valueOf('M'), Item.ingotGold
		});
		ModLoader.AddRecipe(new ItemStack(swordCorrupted, 1), new Object[] {
		      "CIC", "CIC", "MLM", Character.valueOf('C'), darkDiamond, Character.valueOf('I'), Item.ingotIron, Character.valueOf('L'), Item.leather, Character.valueOf('M'), Block.cobblestone
		});
		ModLoader.AddShapelessRecipe(new ItemStack(Block.brick, 1), new Object[] {
			new ItemStack(Block.stone), new ItemStack(lightDiamond, 1)
		});
		ModLoader.AddShapelessRecipe(new ItemStack(Block.obsidian, 1), new Object[] {
			new ItemStack(Block.brick), new ItemStack(lightDiamond, 1)
		});
		ModLoader.AddShapelessRecipe(new ItemStack(Item.redstone, 8), new Object[] {
			new ItemStack(Block.sand), new ItemStack(lightDiamond, 1)
		});
		ModLoader.AddShapelessRecipe(new ItemStack(Item.gunpowder, 1), new Object[] {
			new ItemStack(Item.redstone), new ItemStack(lightDiamond, 1)
		});
		ModLoader.AddShapelessRecipe(new ItemStack(Item.lightStoneDust, 1), new Object[] {
			new ItemStack(Item.gunpowder), new ItemStack(lightDiamond, 1)
		});
		ModLoader.AddShapelessRecipe(new ItemStack(Item.ingotIron, 1), new Object[] {
			new ItemStack(Item.coal), new ItemStack(lightDiamond, 1)
		});
		ModLoader.AddShapelessRecipe(new ItemStack(Item.ingotGold, 1), new Object[] {
			new ItemStack(Item.ingotIron), new ItemStack(lightDiamond, 1)
		});
		ModLoader.AddRecipe(new ItemStack(Item.diamond, 1), new Object[] {
		      " L ", "LGL", " L ", Character.valueOf('L'), lightDiamond, Character.valueOf('G'), Item.ingotGold
		});
		ModLoader.AddRecipe(new ItemStack(itemLense, 1), new Object[] {
		      "LLL", "LGL", "LLL", Character.valueOf('L'), lightEnergy, Character.valueOf('G'), Block.glass
		});
		ModLoader.AddRecipe(new ItemStack(itemLenseBow, 1), new Object[] {
		      "LSs", "LSs", "LSs", Character.valueOf('L'), itemLense, Character.valueOf('S'), Block.cobblestone, Character.valueOf('s'), Item.silk
		});
		ModLoader.AddRecipe(new ItemStack(itemLenseBow, 1), new Object[] {
		      "LSs", "LSs", "LSs", Character.valueOf('L'), itemLense, Character.valueOf('S'), Block.cobblestone, Character.valueOf('s'), plantString
		});
		ModLoader.AddRecipe(new ItemStack(arrowCoal, 3), new Object[] {
		      " C ", "AAA", Character.valueOf('C'), Item.coal, Character.valueOf('A'), Item.arrow
		});
		ModLoader.AddRecipe(new ItemStack(Item.paper, 1), new Object[] {
		      "###", "###", Character.valueOf('#'), plantString
		});
		ModLoader.AddRecipe(new ItemStack(Item.paper, 1), new Object[] {
		      "###", "###", Character.valueOf('#'), Item.silk
		});
		ModLoader.AddRecipe(new ItemStack(chantBook, 1), new Object[] {
		      " D ", "LBL", " L ", Character.valueOf('D'), lightDiamond, Character.valueOf('L'), lightEnergy, Character.valueOf('B'), Item.book
		});
		ModLoader.AddRecipe(new ItemStack(chantDark, 1, 9000), new Object[] {
		      "DDD", " B ",Character.valueOf('D'), darkDiamond, Character.valueOf('B'), Item.book
		});
		ModLoader.AddRecipe(new ItemStack(chantSmite, 1, 9000), new Object[] {
		      "LLL", " B ", Character.valueOf('L'), lightEnergy, Character.valueOf('B'), chantBook
		});
		ModLoader.AddRecipe(new ItemStack(chantHeal, 1, 9000), new Object[] {
		      "RDR", " B ", Character.valueOf('D'), lightDiamond, Character.valueOf('B'), chantBook, Character.valueOf('R'), Block.plantRed
		});
		ModLoader.AddRecipe(new ItemStack(chantMind, 1, 9000), new Object[] {
		      "bDb", " B ", Character.valueOf('D'), lightDiamond, Character.valueOf('B'), chantBook, Character.valueOf('b'), Item.book
		});
		ModLoader.AddRecipe(new ItemStack(blockTrapWood, 1), new Object[] {
		      "PSP", "sss", Character.valueOf('P'), Block.planks, Character.valueOf('S'), Item.silk, Character.valueOf('s'), Item.stick
		});
		ModLoader.AddRecipe(new ItemStack(blockTrapWood, 1), new Object[] {
		      "PSP", "sss", Character.valueOf('P'), Block.planks, Character.valueOf('S'), plantString, Character.valueOf('s'), Item.stick
		});
		ModLoader.AddRecipe(new ItemStack(blockTrapStone, 1), new Object[] {
		      "BSB", "sBs", Character.valueOf('B'), Block.cobblestone, Character.valueOf('S'), Item.silk, Character.valueOf('s'), Item.stick
		});
		ModLoader.AddRecipe(new ItemStack(blockTrapStone, 1), new Object[] {
		      "BSB", "sBs", Character.valueOf('B'), Block.cobblestone, Character.valueOf('S'), plantString, Character.valueOf('s'), Item.stick
		});
		ModLoader.AddRecipe(new ItemStack(blockTrapIron, 1), new Object[] {
		      "ISI", "sIs", Character.valueOf('I'), Item.ingotIron, Character.valueOf('S'), Item.silk, Character.valueOf('s'), Item.stick
		});
		ModLoader.AddRecipe(new ItemStack(blockTrapIron, 1), new Object[] {
		      "ISI", "sIs", Character.valueOf('I'), Item.ingotIron, Character.valueOf('S'), plantString, Character.valueOf('s'), Item.stick
		});
		ModLoader.AddRecipe(new ItemStack(Block.tnt, 2), new Object[] {
		      "LSL", "SGS", "LSL", Character.valueOf('L'), lightDiamond, Character.valueOf('S'), Block.sand, Character.valueOf('G'), Item.gunpowder
		});
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void AddRenderer(Map map)
	{
        map.put(EntityM4DCrawlSpider.class, new RenderM4DCrawlSpider());
        map.put(EntityM4DMadCow.class, new RenderM4DMadCow());
        map.put(EntityM4DDirtEater.class, new RenderM4DDirtEater());
        map.put(EntityM4DCrazyChicken.class, new RenderM4DCrazyChicken());
        map.put(EntityM4DWebbingSpider.class, new RenderM4DCrawlSpider());
        map.put(EntityM4DWebBall.class, new RenderSnowball(itemWebBall.iconIndex));
        map.put(EntityM4DCorruptor.class, new RenderM4DCorruptor());
    }
	
	public static boolean configLoaded = false;
    public static String[] IDlist;
    public static boolean debugMode = false;
    private static int debugSpawnTimer=0;
    public static int prepMin = 15; 
    public static int dayMin = 3; 
    public static int mobLimit = 50;
    public static int score = 0;
    public static float scoreMod = 1F;
    public static int reroutes = 3;
    public static float pathComplexity = 32F;
	
	public static void loadConfig (BufferedReader reader)
    {
		IDlist = new String[32000];
    	for (int id = 0; id < 32000; id++)
    	{
    		IDlist[id]=" ";
    	}
    	String line = null;
    	try
		{
    	line = reader.readLine();
		}
		catch (Exception e)
		{
			System.out.println((new StringBuilder()).append("[M4D] Couldn't read new line in config file.").toString());
			return;
		}
    	while (line != null)
    	{
    		String saveline = line;
    		try
    		{
    			if (line.startsWith("#"))
    			{ // IgnoreComments
    				try
    	    		{
    	    		line = reader.readLine();
    	    		}
    	    		catch (Exception e)
    	    		{
    	    			System.out.println((new StringBuilder()).append("[M4D] Couldn't read new line in config file.").toString());
    	    			return;
    	    		}
    	    		continue;
    			}
    			line.replaceAll(";","=");
    			line.replaceAll(":","=");
    			line.replaceAll(" ","");
    			line.replaceAll("True","true");
    			/*if (line.equals("disableNuclear=true"))
    				{
    				disableNuclear=true;
    				System.out.println((new StringBuilder()).append("[MedievalCraft] Disabled crafting of nuclear devices.").toString());
    				try
    	    		{
    	    		line = reader.readLine();
    	    		}
    	    		catch (Exception e)
    	    		{
    	    			System.out.println((new StringBuilder()).append("[MedievalCraft] Couldn't read new line in config file.").toString());
    	    			return;
    	    		}
    				continue;
    			}*/
    			
    			if (line.startsWith("PreperationTime="))
    			{
    				line = line.replace("PreperationTime=", "");
    				if (line.equals("short"))
    				{
    					prepMin=5;
    				}
    				if (line.equals("medium"))
    				{
    					prepMin=15;
    				}
    				if (line.equals("long"))
    				{
    					prepMin=30;
    				}
    				System.out.println((new StringBuilder()).append("[M4D] Preperation Time set to "+prepMin+" Minutes.").toString());
    				try
    	    		{
    	    		line = reader.readLine();
    	    		}
    	    		catch (Exception e)
    	    		{
    	    			System.out.println((new StringBuilder()).append("[M4D] Couldn't read new line in config file.").toString());
    	    			return;
    	    		}
    				continue;
    			}
    			
    			if (line.startsWith("DayLength="))
    			{
    				line = line.replace("DayLength=", "");
    				if (line.equals("short"))
    				{
    					dayMin=1;
    				}
    				if (line.equals("medium"))
    				{
    					dayMin=3;
    				}
    				if (line.equals("long"))
    				{
    					dayMin=5;
    				}
    				System.out.println((new StringBuilder()).append("[M4D] Day Length set to "+dayMin+" Minutes.").toString());
    				try
    	    		{
    	    		line = reader.readLine();
    	    		}
    	    		catch (Exception e)
    	    		{
    	    			System.out.println((new StringBuilder()).append("[M4D] Couldn't read new line in config file.").toString());
    	    			return;
    	    		}
    				continue;
    			}
    			
    			if (line.startsWith("MobLimit="))
    			{
    				line = line.replace("MobLimit=", "");
    				mobLimit=Integer.parseInt(line);
    				System.out.println((new StringBuilder()).append("[M4D] Mob limit set to: "+mobLimit).toString());
    				try
    	    		{
    	    		line = reader.readLine();
    	    		}
    	    		catch (Exception e)
    	    		{
    	    			System.out.println((new StringBuilder()).append("[M4D] Couldn't read new line in config file.").toString());
    	    			return;
    	    		}
    				continue;
    			}
    			
    			if (line.startsWith("ID"))
    			{
    				line = line.replace("ID", "");
    				String[] components = line.split("=");
    				IDlist[Integer.parseInt(components[1])]=components[0];
    				//System.out.println((new StringBuilder()).append("[MedievalCraft] Configurated ID "+Integer.parseInt(components[1])+" for object "+components[0]).toString());
    				try
    	    		{
    	    		line = reader.readLine();
    	    		}
    	    		catch (Exception e)
    	    		{
    	    			System.out.println((new StringBuilder()).append("[M4D] Couldn't read new line in config file.").toString());
    	    			return;
    	    		}
    				continue;
    			}
    			System.out.println((new StringBuilder()).append("[M4D] Can't read '"+saveline+"' in the config file!").toString());
    		}
    		catch (Exception e)
    		{
    			System.out.println((new StringBuilder()).append("[M4D] Can't read '"+saveline+"' in the config file!").toString());
    			//e.printStackTrace();
    		}
    		try
    		{
    		line = reader.readLine();
    		}
    		catch (Exception e)
    		{
    			System.out.println((new StringBuilder()).append("[M4D] Couldn't read new line in config file.").toString());
    			return;
    		}
    		//read next line
    	}
    }
	
	public static int getId (String item, int standardID)
    {
    	if (configLoaded == false)
    	{ // config wasn't loaded
    		return standardID;
    	}
    	try
    	{
    		for (int i=0;i < IDlist.length; i++)
    		{
    			//if (item.equals(IDlist[i]))
    			if (IDlist[i].equals(item))
    			{ // Found a new ID
    				if (i!=standardID)
    				{ // Not really new...
    					System.out.println((new StringBuilder()).append("[M4D] New ID assigned to object "+item+": "+i).toString());
    				}
    				return i;
    			}
    		}
    	}
    	catch (Exception e)
    	{
    		e.printStackTrace();
    		System.out.println((new StringBuilder()).append("[M4D] Error while trying to access IDlist, config wasn't loaded properly!").toString());
    		return standardID;
    	}
    	System.out.println((new StringBuilder()).append("[M4D] ERROR! Couldn't find IDList entry for object "+item).toString());
    	return standardID;
    }
	
	public static TileEntityShrine shrine = null;
	public static int spawnShrineTimer = 50;
	public static boolean gameOver = false;
	public static int gameOverTimer = 0;
	
	/**
	 * Method called each tick, while player is in GUI.
	 * @return 
	 */
	public boolean OnTickInGUI(Minecraft minecraft, GuiScreen guiscreen)
	{
		return true;
	}
	
	/**
	 * Method called each tick, while player is NOT in a GUI, f.e. moving around and stuff..
	 * @return 
	 */
	public boolean OnTickInGame(Minecraft minecraft)
	{
		if(minecraft.theWorld.multiplayerWorld || minecraft.isGamePaused)
		{
			return true;
		}
		
		if(shrine!=null && shrine.worldObj!=minecraft.theWorld)
		{
			shrine=null;
			score=0;
			gameOver=false;
		}
		
		if (gameOver)
		{
			gameOverTimer--;
			if (gameOverTimer<=0)
			{
		    	ModLoader.getMinecraftInstance().ingameGUI.addChatMessage("THE SHRINE WAS DESTROYED, THE ZOMBIES HAVE WON!");
		    	ModLoader.getMinecraftInstance().ingameGUI.addChatMessage("Final Score: "+score);
		    	ModLoader.getMinecraftInstance().ingameGUI.addChatMessage("Reached Wave: "+shrine.waveCount);
		    	minecraft.thePlayer.setEntityDead();
		    	gameOverTimer=500;
			}
		}
		if (!debugMode && 
				Keyboard.isKeyDown(Keyboard.KEY_NUMPAD2)&&Keyboard.isKeyDown(Keyboard.KEY_NUMPAD9)&&Keyboard.isKeyDown(Keyboard.KEY_NUMPAD1))
		{
			debugMode=true;
			ModLoader.getMinecraftInstance().ingameGUI.addChatMessage("Debug Mode enabled!");
		}
		if (debugSpawnTimer>=0)
		{
			debugSpawnTimer--;
		}
		if (debugMode)
		{
			if (debugSpawnTimer<=0)
			{
			checkSpawnCommands(minecraft);
			}
			
			if (Keyboard.isKeyDown(Keyboard.KEY_END))
			{
				shrine.time+=50;
			}
		}
		
		if (shrine==null)
		{
			spawnShrineTimer--;
			if (spawnShrineTimer<=0)
			{
				spawnShrineTimer+=10;
				Random random = new Random();
				int x = (random.nextInt(101)+random.nextInt(101))/2-50+(int)minecraft.thePlayer.posX;
				int z = (random.nextInt(101)+random.nextInt(101))/2-50+(int)minecraft.thePlayer.posZ;
				int y = 128;
				for (; y > 1; y--)
				{
					if (minecraft.theWorld.isBlockOpaqueCube(x, y-1, z))
					{
						break;
					}
				}
				if (y>1 && minecraft.theWorld.getBlockId(x, y, z)==0)
				{
					ModLoader.getMinecraftInstance().ingameGUI.addChatMessage("New Shrine created at X:"+x+" / Z:"+z+"!");
					minecraft.theWorld.setBlock(x, y, z, blockShrine.blockID);
				}
			}
		}
		else
		{
			if (shrine.ticked)
			{
				minecraft.theWorld.setWorldTime(syncTimeWithShrine());
				//System.out.println("Time: "+minecraft.theWorld.getWorldTime());
				shrine.ticked=false;
			}
		}
		
		if(minecraft.theWorld.rand.nextInt(50)==0)
		{
			updateScoreMod(minecraft);
		}
		return true;
	}
	
	public void updateScoreMod(Minecraft minecraft)
	{
		float dif = getDifficultyRating(minecraft.theWorld);
		if(minecraft.theWorld.difficultySetting==0)
		{
			dif*=0.8F;
		}
		if (prepMin==5)
		{
			dif*=1.1F;
		}
		if (prepMin==30)
		{
			dif*=0.8F;
		}
		if (dayMin==1)
		{
			dif*=1.2F;
		}
		if (dayMin==5)
		{
			dif*=0.9F;
		}
		scoreMod=dif;
	}
	
	public static void score(int sc)
	{
		score+=scoreMod*sc;
	}
	
	/*
	 * Will control the time and set it in following manner:
	 * If shrine-clock is below 0 (-1200 - 0), it simulates moon-fall and sun-rise, as the mobwave was defeated (-1200)
	 * It will then display the full day animation, based on the dayMin(ute) length.
	 * Once the day's up, 1200 frames (one minute) will be dedicated to sunset+moon-rise.
	 * Then the moon will freeze in zenit and mob waves start.
	 * Listen&Repeat.
	 */
	private int syncTimeWithShrine()
	{
		int curtime = shrine.time;
		if (curtime<-600)
		{
			curtime+=1200;
			return (int) (curtime*7.5D+18300);
		}
		if (curtime<0)
		{
			curtime+=600;
			return curtime*3+22200;
		}
		int maxTime = 1200*dayMin;
		if (shrine.waveCount==0)
		{
			maxTime =1200*prepMin;
		}
		if (curtime<=maxTime)
		{
			return (int)((double)shrine.time / (double)maxTime * 12000D);
		}
		curtime-=maxTime;
		if (curtime<= 600)
		{
			return curtime*3+12000;
		}
		curtime-=600;
		if (curtime<=600)
		{
			return (int) (13800+curtime*7.5D);
		}
		faketimer++;
		if (faketimer==600)
		{
			faketimer=-1;
			return 18600;
		}
		return 17700+faketimer;
		
	}
	
	private static int faketimer = 0;
	
	public static float getDifficultyRating(World world)
	{
		float value = 1F;
		switch(world.difficultySetting)
		{
		case 0: value*=0.3F; break;
		case 1: value*=0.7F; break;
		case 2: value*=1.0F; break;
		case 3: value*=1.5F; break;
		}
		return value;
	}
	
    private static mod_Mine4Dead sendInstance;
    
    private void checkSpawnCommands(Minecraft minecraft)
    {
    	EntityPlayer entityplayer = minecraft.thePlayer;
		World world = entityplayer.worldObj;
		String mobname = null;
		if (Keyboard.isKeyDown(Keyboard.KEY_NUMPAD1))
		{
			mobname="Corruptor";
		}
		if (Keyboard.isKeyDown(Keyboard.KEY_NUMPAD2))
		{
			mobname="Webbing Spider";
		}
		if (Keyboard.isKeyDown(Keyboard.KEY_NUMPAD3))
		{
			mobname="Corrupted Corpse";
		}
		if (Keyboard.isKeyDown(Keyboard.KEY_NUMPAD4))
		{
			mobname="Mad Cow";
		}
		if (Keyboard.isKeyDown(Keyboard.KEY_NUMPAD5))
		{
			mobname="Crazy Chicken";
		}
		if (Keyboard.isKeyDown(Keyboard.KEY_NUMPAD6))
		{
			mobname="Dirt Eater";
		}
		if (Keyboard.isKeyDown(Keyboard.KEY_NUMPAD7))
		{
			mobname="Dark Zombie";
		}
		if (Keyboard.isKeyDown(Keyboard.KEY_NUMPAD8))
		{
			mobname="Buster";
		}
		if (mobname==null)
		{
			return;
		}
		EntityLiving mob = (EntityM4DMob)EntityList.createEntityInWorld(mobname, world);
    	if (mob == null)
    	{
    		return;
    	}
    	float f1 = ((float)entityplayer.posX+world.rand.nextFloat())-world.rand.nextFloat()+20F;
    	float f2 = ((float)entityplayer.posY);
        float f3 = ((float)entityplayer.posZ+world.rand.nextFloat())-world.rand.nextFloat();
        //System.out.println ("Spawning at "+f1+"/"+f2+"/"+f3);
        mob.setLocationAndAngles(f1, f2, f3, world.rand.nextFloat() * 360F, 0.0F);
        mob.spawnExplosionParticle();
        world.entityJoinedWorld(mob);
        debugSpawnTimer=20;
    }
    
	public static void sendStringArray (String[] msg)
    {
        Packet230ModLoader packet = new Packet230ModLoader();
        packet.packetType = 0;
        packet.dataString = msg;
        ModLoaderMp.SendPacket(sendInstance, packet);        
    }
	
	public void HandlePacket(Packet230ModLoader packet)
    { // SMP-PacketHandler
    	switch(packet.packetType)
    	{
    		case 0: // String
    		{
    			String command= packet.dataString[0];
    			if(command.startsWith("Chat:"))
    			{
    				command.replaceAll("Chat:", "");
    				ModLoader.getMinecraftInstance().ingameGUI.addChatMessage(command);
    			}
    		}
    	}
    }
	
    public static void sendStringArray (String[] msg, EntityPlayer entityplayer)
    { // Dummy
    	sendStringArray(msg);
    }
    
    public static void triggerGameOver()
    {
    	gameOver=true;
    }
    
    public static void createCorruption(World world, double i, double j, double k, int number)
    {
    	createCorruption(world,(int)i, (int)j,(int)k, number);
    }
    
    public static void createCorruption(World world, int i, int j, int k, int number)
    {
    	while(j>1 && world.isBlockOpaqueCube(i, j-1, k)==false)
    	{
    		j--;
    	}
    	if(world.getBlockId(i, j-1, k)==blockCorruption.blockID ||
    				world.getBlockId(i, j-1, k)==blockCorruptionWeak.blockID)
    	{
    		j--;
    	}
    	for (int r = 0; r < number; r++)
    	{
    		if (world.getBlockId(i, j, k)==blockCorruption.blockID ||
    				world.getBlockId(i, j, k)==blockCorruptionWeak.blockID)
    		{
    			int x=i;
    			int y=j;
    			int z=k;
    			if (world.rand.nextBoolean())
    			{
    				x--;
    			}
    			else
    			{
    				x++;
    			}
    			if (world.rand.nextBoolean())
    			{
    				z--;
    			}
    			else
    			{
    				z++;
    			}
    			while(y>1 && world.isBlockOpaqueCube(x, y-1, z)==false)
    	    	{
    	    		y--;
    	    	}
    			if (world.getBlockId(x, y, z)!=blockCorruption.blockID && !world.isBlockOpaqueCube(x, y, z))
    			{
    				world.setBlockWithNotify(x, y, z, blockCorruptionWeak.blockID);
    			}
    		}
    		else
    		{
    			world.setBlockWithNotify(i, j, k, blockCorruptionWeak.blockID);
    		}
    	}
    }
	
	public String Version()
	{
		return "0.80";
	}
}